/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.coordinates.ColumnPosArgument;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraftforge.server.ServerLifecycleHooks;
import net.minecraftforge.server.command.EnumArgument;
import pregenerator.common.commands.arguments.CenterArgument;
import pregenerator.common.commands.arguments.RadiusArgument;
import pregenerator.common.generator.GenerationType;
import pregenerator.common.generator.tasks.BaseTask;
import pregenerator.common.generator.tasks.CircleExpansionTask;
import pregenerator.common.generator.tasks.CircleTask;
import pregenerator.common.generator.tasks.SquareExpansionTask;
import pregenerator.common.generator.tasks.SquareTask;
import pregenerator.common.manager.ServerManager;
import pregenerator.common.utils.misc.CommandBuilder;
import pregenerator.common.utils.misc.CommandWrapper;
import pregenerator.common.utils.misc.GenShape;

public class GenCommand {
    public static GenCommand INSTANCE = new GenCommand();

    public CommandBuilder createGenStart(boolean advArgs) {
        CommandBuilder builder = new CommandBuilder("gen");
        Command radius = GenCommand::executeRadius;
        builder.addLiteral("radius");
        builder.addArgument("Task Name", (ArgumentType<?>)StringArgumentType.word());
        if (advArgs) {
            builder.addArgument("Shape", (ArgumentType<?>)EnumArgument.enumArgument(GenShape.class));
            builder.addArgument("Center", CenterArgument.center());
            builder.addArgument("Radius", RadiusArgument.integer(1, 25000), (Command<CommandSourceStack>)radius);
            builder.addArgument("Dimension", (ArgumentType<?>)DimensionArgument.m_88805_(), (Command<CommandSourceStack>)radius);
            builder.addArgument("Generation Type", (ArgumentType<?>)EnumArgument.enumArgument(GenerationType.class), (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)GenCommand::listSuggestions), (Command<CommandSourceStack>)radius).popTop();
        } else {
            builder.addArgument("Shape", (ArgumentType<?>)StringArgumentType.word(), (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)GenCommand::listShape));
            builder.addArgument("Center", (ArgumentType<?>)ColumnPosArgument.m_118989_(), (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)CenterArgument::listSimpleSuggestion));
            builder.addArgument("Radius", (ArgumentType<?>)IntegerArgumentType.integer((int)1, (int)25000), (Command<CommandSourceStack>)radius);
            builder.addArgument("Dimension", (ArgumentType<?>)DimensionArgument.m_88805_(), (Command<CommandSourceStack>)radius);
            builder.addArgument("Generation Type", (ArgumentType<?>)StringArgumentType.word(), (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)GenCommand::listSuggestions), (Command<CommandSourceStack>)radius).popTop();
        }
        Command expansion = GenCommand::executeExpansion;
        builder.addLiteral("expansion");
        builder.addArgument("Task Name", (ArgumentType<?>)StringArgumentType.word());
        if (advArgs) {
            builder.addArgument("Shape", (ArgumentType<?>)EnumArgument.enumArgument(GenShape.class));
            builder.addArgument("Center", CenterArgument.center());
            builder.addArgument("Min Radius", RadiusArgument.integer(1));
            builder.addArgument("Max Radius", RadiusArgument.integer(1), (Command<CommandSourceStack>)expansion);
            builder.addArgument("Dimension", (ArgumentType<?>)DimensionArgument.m_88805_(), (Command<CommandSourceStack>)expansion);
            builder.addArgument("Generation Type", (ArgumentType<?>)EnumArgument.enumArgument(GenerationType.class), (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)GenCommand::listSuggestions), (Command<CommandSourceStack>)expansion).popTop();
        } else {
            builder.addArgument("Shape", (ArgumentType<?>)StringArgumentType.word(), (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)GenCommand::listShape));
            builder.addArgument("Center", (ArgumentType<?>)ColumnPosArgument.m_118989_(), (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)CenterArgument::listSimpleSuggestion));
            builder.addArgument("Min Radius", (ArgumentType<?>)IntegerArgumentType.integer((int)1));
            builder.addArgument("Max Radius", (ArgumentType<?>)IntegerArgumentType.integer((int)1), (Command<CommandSourceStack>)expansion);
            builder.addArgument("Dimension", (ArgumentType<?>)DimensionArgument.m_88805_(), (Command<CommandSourceStack>)expansion);
            builder.addArgument("Generation Type", (ArgumentType<?>)StringArgumentType.word(), (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)GenCommand::listSuggestions), (Command<CommandSourceStack>)expansion).popTop();
        }
        Command border = GenCommand::executeWorldBorder;
        builder.addLiteral("worldborder");
        builder.addArgument("Task Name", (ArgumentType<?>)StringArgumentType.word(), (Command<CommandSourceStack>)border);
        builder.addArgument("Dimension", (ArgumentType<?>)DimensionArgument.m_88805_(), (Command<CommandSourceStack>)border);
        if (advArgs) {
            builder.addArgument("Generation Type", (ArgumentType<?>)EnumArgument.enumArgument(GenerationType.class), (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)GenCommand::listSuggestions), (Command<CommandSourceStack>)border).popTop();
        } else {
            builder.addArgument("Generation Type", (ArgumentType<?>)StringArgumentType.word(), (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)GenCommand::listSuggestions), (Command<CommandSourceStack>)border).popTop();
        }
        return builder;
    }

    private static CompletableFuture<Suggestions> listShape(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        String s = builder.getRemaining().toLowerCase(Locale.ROOT);
        Stream.of(GenShape.values()).filter(e -> e.toString().toLowerCase(Locale.ROOT).startsWith(s)).forEach(e -> builder.suggest(e.toString()));
        return builder.buildFuture();
    }

    private static CompletableFuture<Suggestions> listSuggestions(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        String s = builder.getRemaining().toLowerCase(Locale.ROOT);
        Stream.of(GenerationType.values()).filter(e -> e.toString().toLowerCase(Locale.ROOT).startsWith(s)).forEach(e -> builder.suggest(e.toString(), (Message)e.createSuggestion()));
        return builder.buildFuture();
    }

    private static int executeWorldBorder(CommandContext<CommandSourceStack> source) {
        CommandWrapper wrapper = new CommandWrapper(source);
        String name = wrapper.get("Task Name", String.class);
        ResourceLocation dimension = wrapper.getOrDefault("Dimension", ResourceLocation.class, wrapper.getSource().m_81372_().m_46472_().m_135782_());
        GenerationType gen = wrapper.hasValue("Generation Type", String.class) ? GenerationType.valueOf(wrapper.get("Generation Type", String.class)) : wrapper.getOrDefault("Generation Type", GenerationType.class, GenerationType.FAST_CHECK_GEN);
        WorldBorder border = ServerLifecycleHooks.getCurrentServer().m_129880_(ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)dimension)).m_6857_();
        int size = (int)(border.m_61959_() / 2.0) >> 4;
        if (size > 500) {
            wrapper.sendErrorMessage("Task Exceeds the max radius of 500 chunks");
            return 0;
        }
        ServerManager.INSTANCE.startTask(new SquareTask(name, (ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)dimension), gen.getIndex(), new ChunkPos((int)border.m_6347_() >> 4, (int)border.m_6345_() >> 4), size), wrapper.getSenderId(), wrapper);
        return 0;
    }

    private static int executeRadius(CommandContext<CommandSourceStack> source) {
        CommandWrapper wrapper = new CommandWrapper(source);
        String name = wrapper.get("Task Name", String.class);
        GenShape shape = wrapper.hasValue("Shape", String.class) ? GenShape.valueOf(wrapper.get("Shape", String.class)) : wrapper.get("Shape", GenShape.class);
        BlockPos center = CenterArgument.getVanillaBlockPos(wrapper.get("Center", Coordinates.class), (CommandSourceStack)source.getSource());
        int radius = wrapper.get("Radius", Integer.class);
        ResourceLocation dimension = wrapper.getOrDefault("Dimension", ResourceLocation.class, wrapper.getSource().m_81372_().m_46472_().m_135782_());
        if (ServerLifecycleHooks.getCurrentServer().m_129880_(ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)dimension)) == null) {
            ((CommandSourceStack)source.getSource()).m_81352_((Component)new TextComponent("Dimension does not exist"));
            return 0;
        }
        if (radius > 500) {
            wrapper.sendErrorMessage("Task Exceeds the max radius of 500 chunks");
            return 0;
        }
        GenerationType gen = wrapper.hasValue("Generation Type", String.class) ? GenerationType.valueOf(wrapper.get("Generation Type", String.class)) : wrapper.getOrDefault("Generation Type", GenerationType.class, GenerationType.FAST_CHECK_GEN);
        BaseTask task = null;
        switch (shape) {
            case SQUARE: {
                task = new SquareTask(name, (ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)dimension), gen.getIndex(), new ChunkPos(center.m_123341_(), center.m_123343_()), radius);
                break;
            }
            case CIRCLE: {
                task = new CircleTask(name, (ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)dimension), gen.getIndex(), new ChunkPos(center.m_123341_(), center.m_123343_()), radius);
            }
        }
        if (task == null) {
            wrapper.sendErrorMessage("Couldn't create Task!");
            return 0;
        }
        ServerManager.INSTANCE.startTask(task, wrapper.getSenderId(), wrapper);
        return 0;
    }

    private static int executeExpansion(CommandContext<CommandSourceStack> source) {
        int maxRadius;
        CommandWrapper wrapper = new CommandWrapper(source);
        String name = wrapper.get("Task Name", String.class);
        GenShape shape = wrapper.hasValue("Shape", String.class) ? GenShape.valueOf(wrapper.get("Shape", String.class)) : wrapper.get("Shape", GenShape.class);
        BlockPos center = CenterArgument.getVanillaBlockPos(wrapper.get("Center", Coordinates.class), (CommandSourceStack)source.getSource());
        int minRadius = wrapper.get("Min Radius", Integer.class);
        if (minRadius > (maxRadius = wrapper.get("Max Radius", Integer.class).intValue())) {
            wrapper.sendErrorMessage("Min Radius is not allowed to be bigger then Max Radius");
            return 0;
        }
        if (maxRadius * maxRadius - minRadius * minRadius > 250000) {
            wrapper.sendErrorMessage("Expansions bigger then 1 Million Chunks are not allowed!");
            return 0;
        }
        ResourceLocation dimension = wrapper.getOrDefault("Dimension", ResourceLocation.class, wrapper.getSource().m_81372_().m_46472_().m_135782_());
        if (ServerLifecycleHooks.getCurrentServer().m_129880_(ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)dimension)) == null) {
            ((CommandSourceStack)source.getSource()).m_81352_((Component)new TextComponent("Dimension does not exist"));
            return 0;
        }
        GenerationType gen = wrapper.hasValue("Generation Type", String.class) ? GenerationType.valueOf(wrapper.get("Generation Type", String.class)) : wrapper.getOrDefault("Generation Type", GenerationType.class, GenerationType.FAST_CHECK_GEN);
        BaseTask task = null;
        switch (shape) {
            case SQUARE: {
                task = new SquareExpansionTask(name, (ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)dimension), gen.getIndex(), new ChunkPos(center.m_123341_(), center.m_123343_()), minRadius, maxRadius);
                break;
            }
            case CIRCLE: {
                task = new CircleExpansionTask(name, (ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)dimension), gen.getIndex(), new ChunkPos(center.m_123341_(), center.m_123343_()), minRadius, maxRadius);
            }
        }
        if (task == null) {
            wrapper.sendErrorMessage("Couldn't create Task!");
            return 0;
        }
        ServerManager.INSTANCE.startTask(task, wrapper.getSenderId(), wrapper);
        return 0;
    }
}

